*******************************************************************************
*                         680xx Grundprogramm init                            *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                            Initialisierungen                                *
*******************************************************************************


vekdef:                         * Fr Anwendervektoren
 jmp intlvx-basis               * Sprungbefehle werden auf Adressen
 jmp intlvx-basis               * geschrieben, die fr Benutzeranwendungen
 jmp traperr-basis              * reserviert sind
 jmp trap0a-basis
 jmp ciin-basis
 jmp cstsin-basis
 jmp co-basis

linedef:                        * Auch hier, blo sind dies Ausnahmebedingungen
 jmp trap1a-basis
 jmp lineaer-basis
 jmp linefer-basis

mausdef:                        * Eingabegert initialisieren
 jmp mausaus0-basis
 jmp absmaus0-basis

exinit:                         * Init der Variablen und Init a5/a7
 bsr seta5                      * a5 setzen
init:                           * Internes Init
 movem.l d0-d7/a0-a7,regsave(a5)
 bsr flinit                     * Floppy-Init am Anfang wegen Floppy-Motor
 move.b keys.w,keydil(a5)       * Stellung der DIL-Schalter merken
 bsr uhrinit                    * UHR-Init, muss zu Anfang wg. NVRAM
 cmp.b #3, uhrausw(a5)
 bne.s init01
 lea nvrbuff(a5), a0
 clr (a0)
 bsr getsys
 tst d0
 bne.s init01                   * NVRAM Daten nicht korrekt
 lea nvrbuff(a5), a0
 move #$a5c3, (a0)              * als Kennung, dass Daten gelesen
 move.b 2(a0), keydil(a5)       * DIP-Key berschreiben
init01:
 bsr srdinit                    * SRAMDISK initialisieren
 bsr erakreuz                   * Fadenkreuz ausschalten
 move.b #%01000000,proma2.w     * Promer neutral stellen (Bei Promer2 egal)
 clr.b proma5.w                 * Promer2 neutral stellen (Bei Promer egal)
 clr.b iodir(a5)                * Kein CTRL-A bei CO2
 clr oldsize(a5)                * Keine alte Figur gltig
 clr.b synstate(a5)             * Kein Syncrol-Impuls abgefragt
 clr.b flip(a5)                 * Keine Seitenumschaltung
 clr.b flip1(a5)
 clr.b gdpcol(a5)               * S/W-GDP
 move.b #$0a, colport.w         * Testmuster schreiben
 move.b colport.w, d0
 cmp.b #$0a, d0                 * Testmuster bernommen?
 bne.s init01a                  * nein, dann S/W-GDP
 move.b #1, gdpcol(a5)          * sonst Farb-GDP
 move.b #1, colport.w           * Vordergrundfarbe wiederherstellen
init01a:
 move.b #$01, fgcolor(a5)       * Vordergrundfarbe fr GDP (1 = wei)
 clr.b bgcolor(a5)              * Hintergrundfarbe (0 = schwarz)
 clr.b xormode(a5)              * Kein Verknpfungsmode
 clr.b transmod(a5)             * Transparentmode ein
 clr tur1x(a5)                  * Turtle auf Null
 clr tur1y(a5)
 clr tur1phi(a5)                * Winkel auf Null
 clr turx(a5)
 clr tury(a5)
 clr turphi(a5)
 move.b #1,turdo(a5)            * Turtle down
 move.b #1,first(a5)            * Turtle erster Aufruf
 move.b #1,iostat(a5)           * Nur Fehlerausgabe
 clr.b serflag(a5)              * Serielle Schnittstelle nicht ansprechen
 move.b #2,iostatb(a5)          * ci/csts/ci2 nicht umlenken
 move #2,passflag(a5)           * Ausgabe bei CO2 eingeschaltet
 move #2,errflag(a5)            * Ausgabe bei CO2, nur Fehlerausgabe bei ASS
 clr.b curon(a5)                * Cursor bei CO2 an
 clr.b escmerker(a5)            * Kein ESC bei CO
 tas.b menflag(a5)              * Nach Reset wieder mit Hardcopy
 bclr.b #2,menflag(a5)          * Grundprogramm nicht als Aufruf
 move.b #%00000101,tracflag(a5) * Mit Regdump / TRAP+JSR Direktausfhrung
                                * Ohne Listen
 clr.b coscroll(a5)             * Scroll immer auf Null stellen
 clr.b page1.w                  * Kein Scroll bisher

init1:
 lea basis(pc),a0
 movea.l a0, a2
 move.l a0,d1
 beq.s init3                    * Grundprogramm auf Null, dann nicht bertragen
 suba.l a1,a1                   * Zieladresse = 0
 move #$100-1,d2                * $100 Langworte bertragen
init2:
 move.l (a0)+,(a1)              * Wert bertragen
 add.l d1,(a1)+                 * Adresse addieren
dbra d2,init2
init3:
 cmp.l #$a140557a,poweron(a5)   * Wenn Power an, dann Ende
 beq getstack                   * Stack nach d0
 bsr clrall                     * Bildschirm lschen
 bsr setpen                     * Schreiben
 lea copyr(pc),a0               * Copyright nur einmal am Anfang ausgeben
 moveq #$00,d0
 moveq #100,d2
 bsr centertxt                  * Copyright ausgeben

 lea copyr2(pc),a0
 moveq #$33,d0
 moveq #60,d2
 bsr centertxt

 lea ausbuf(a5), a0
 lea copyr3(pc), a1
init3a:
 move.b (a1)+, (a0)+            * Copyright3 nach ausbuf
 bne.s init3a
 subq.l #1, a0                  * Null raus
 bsr prtvers                    * Versionsnummer nach a0
 subq.l #1, a0                  * Null raus
 lea copyr4(pc), a1
init3b:
 move.b (a1)+, (a0)+            * Copyright4 nach ausbuf
 bne.s init3b
 lea ausbuf(a5), a0
 moveq #$11,d0
 moveq #20,d2
 bsr centertxt
 moveq #15,d0                   * 1,5 Sekunden
 bsr delay                      * warten

 cmpa.l #0, a2                  * Basis = 0 ?
 beq.s init3c                   * ja
 movea.l #$400, a0              * sonst Editorstart auf $400
 bra.s init3d
init3c:
 lea $2000(a5),a0               * Adresse fr Editor
init3d:
 move.l a0,stxtxt(a5)           * Anfang
 move.l a0,akttxt(a5)           * und Aktuell
 move.l a0,etxtxt(a5)           * und Ende
 clr.b (a0)                     * Endekennung
 clr.b lrand(a5)                * Linker Rand im Editor auf Null
 clr.b insl(a5)                 * Voreinstellungen Editor
 adda.l #$A000, a0              * Assembler 40KB hinter Editor
 move.l a0,pcorg(a5)
 clr.b debug(a5)                * Debug aus
 move.b #$11,groesse(a5)        * Schriftgre gleich auf 80 Zeichen
 btst.b #3, keydil(a5)
 beq.s init3e                   * keine GDP64HS
 move.b #$02, cotempo(a5)       * Standard Hardscrollwert
 bra.s init3f
init3e:
 clr.b cotempo(a5)              * Software-Scroll bei co2-Ausgabe
init3f:
 bsr editeiin                   * Init Tabulatoren
 bsr editem                     * Init Macros
 move.b #5,akteprom(a5)         * Promers 2764 voreingestellt
 lea vekdef(pc),a0              * Anwendervektoren
 lea vekdest(a5),a1             * Ziel
 lea basis(pc),a2               * Additionsadresse
 move.l a2,d1
 moveq #7-1,d2                  * 7 Werte
init4:
 move (a0)+,(a1)+               * JMP-Befehle bertragen
 move.l (a0)+,(a1)
 add.l d1,(a1)+                 * Basis addieren
dbra d2,init4
 lea linedef(pc),a0
 lea trap1(a5),a1               * Jetzt trap1a, linea + linef definieren
 moveq #3-1,d2
init5:
 move (a0)+,(a1)+
 move.l (a0)+,(a1)
 add.l d1,(a1)+
dbra d2,init5
 move.l cpuwert(pc), d0
 cmp.l #1, d0
 beq.s init6a                   * init6 nicht fr 68008
 lea vekdef(pc),a0
 lea intlv1(a5),a1              * Jetzt 68000-Interrupt-Ebenen
 moveq #4-1,d2
init6:
 move (a0),(a1)+
 move.l 2(a0),(a1)
 add.l d1,(a1)+
dbra d2,init6
init6a:
 lea mausdef(pc),a0
 lea mausadr0(a5),a1
 moveq #2-1,d2                  * Jetzt Eingabegert (Maus)
init7:
 move (a0)+,(a1)+
 move.l (a0)+,(a1)
 add.l d1,(a1)+
dbra d2,init7                   * bertragung aller Vektoren abgeschlossen
 move.b keydil(a5),d1           * DIL-Schalter holen
 move.b #$80,d0                 * Bit 7 setzen
 move.b d0,menflag(a5)          *
 lsr #3,d1                      * Bit 3 auf Bit 0
 and.b #1,d1                    * Nur Bit 0 lassen
 move.b d1, ioflag(a5)
 clr.b aktser(a5)
 move.b #$1e,ser3.w             * Standarteinstellung SER
 move.b #$0b,ser2.w
 cmp.b #$1e,ser3.w
 bne.s init7a                   * Nicht vorhanden
 cmp.b #$0b,ser2.w
 bne.s init7a                   * Nicht vorhanden
 bset.b #2, ioflag(a5)          * SER ist vorhanden
 move.b #1, aktser(a5)          * SER ist aktueller Kanal
 lea nvrbuff(a5), a0
 cmp #$a5c3, (a0)               * NVRAM Daten?
 bne.s init7a                   * nein
 move.b 8(a0), d0
 move.b 9(a0), d1
 bsr siinit
init7a:
 move.b ser2c.w, d0             * Interrupt Vector Reg SER2
 cmp.b #$0f, d0                 * Startwert nach RESET
 bne.s init8                    * keine SER2
 move.b #$5a, ser2c.w           * Testwert
 cmp.b #$5a, ser2c.w            * ist drinn?
 bne.s init8                    * nein, doch keinen SER2
 move.b d0, ser2c.w             * wieder herstellen
 move.b #$10, d0                * SER2 Kanal A initialisieren
 lea nvrbuff(a5), a0
 cmp #$a5c3, (a0)               * NVRAM Daten?
 bne.s init7b                   * nein
 adda.l #10, a0                 * Auf SER2 Kanal A
 bra.s init7c
init7b:
 lea s2bd9600(pc), a0           * 9600,E,8,1
init7c:
 bsr siinit
 move.b #$11, d0                * SER2 Kanal B initialisieren
 lea nvrbuff(a5), a0
 cmp #$a5c3, (a0)               * NVRAM Daten?
 bne.s init6d                   * nein
 adda.l #16, a0                 * Auf SER2 Kanal B
 bra.s init6e
init6d:
 lea s2bd9600(pc), a0           * 9600,E,8,1
init6e:
 bsr siinit
 bset.b #3, ioflag(a5)          * SER2-Bit
 tst.b aktser(a5)               * schon ne SER da?
 bne.s init8                    * jo, dann weiter
 move.b #2, aktser(a5)          * sonst Kanal A der SER2 aktuell
 move.b $01, ser2f.w            * LED Kanal A an
init8:
 move.b #1,optflag(a5)          * Deutscher Zeichensatz an
 move.l #'user',fontname(a5)    * Name des User-Zeichensatzes setzen
 move.b #2,dflag0(a5)           * Druckerinit nur einmal (Deutscher Zeichensatz)
 clr.b dflag1(a5)
 move.b #65,dflag2(a5)          * Zeilen pro Seite
 clr.b dflag3(a5)               * Linker Rand
 st drsave(a5)                  * Keine selbstdefinierten Befehle
                                * Init fr Grafik-Paket
 clr.b gdpvpage(a5)             * Leseseite
 clr.b gdpwpage(a5)             * und Schreibseite auf Null
 clr.b gdpscroll(a5)            * Kein Scroll bisher
 clr.b gdpxor(a5)               * Kein XOR-Mode
 move.b #1,gdpcolor(a5)         * Farbe ist wei
 bsr clutinit                   * CLUT auf Standartwerte einstellen
 bsr mausaus                    * Maus rcksetzen
 bsr drbefinit                  * Drucker-Befehle ins Ram kopieren
 bsr casinit                    * Kassetteninterface ein
 bsr loinit                     * Drucker init
 bsr ciinit2                    * ci2 init
 bsr mausaus                    * Maus rcksetzen
 bsr symloesche
 move.l #$a140557a,poweron(a5)  * Power ist an
 bra getstack                   * Stack in d0 zurckliefern

                                                                                                                                                                                                                                                       